define(['./_Map', './_Set', './_WeakMap'], function(Map, Set, WeakMap) {

  'use strict';

  /** `Object#toString` result references. */
  var mapTag = '[object Map]',
      objectTag = '[object Object]',
      setTag = '[object Set]',
      weakMapTag = '[object WeakMap]';

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /** Used to resolve the decompiled source of functions. */
  var funcToString = Function.prototype.toString;

  /**
   * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
   * of values.
   */
  var objectToString = objectProto.toString;

  /** Used to detect maps, sets, and weakmaps. */
  var mapCtorString = Map ? funcToString.call(Map) : '',
      setCtorString = Set ? funcToString.call(Set) : '',
      weakMapCtorString = WeakMap ? funcToString.call(WeakMap) : '';

  /**
   * Gets the `toStringTag` of `value`.
   *
   * @private
   * @param {*} value The value to query.
   * @returns {string} Returns the `toStringTag`.
   */
  function getTag(value) {
    return objectToString.call(value);
  }

  // Fallback for IE 11 providing `toStringTag` values for maps, sets, and weakmaps.
  if ((Map && getTag(new Map) != mapTag) ||
      (Set && getTag(new Set) != setTag) ||
      (WeakMap && getTag(new WeakMap) != weakMapTag)) {
    getTag = function(value) {
      var result = objectToString.call(value),
          Ctor = result == objectTag ? value.constructor : null,
          ctorString = typeof Ctor == 'function' ? funcToString.call(Ctor) : '';

      if (ctorString) {
        switch (ctorString) {
          case mapCtorString: return mapTag;
          case setCtorString: return setTag;
          case weakMapCtorString: return weakMapTag;
        }
      }
      return result;
    };
  }

  return getTag;
});
